/*
 The Techlabs Pure MVC Tutorial
 Copyright (c) 2009 Pedro Furtado (pedro.furtado@gmail.com)
 Your reuse is governed by the Creative Commons Attribution 3.0 License
*/

package com.techlabs.puremvc.view
{
	import com.techlabs.puremvc.ApplicationFacade;
	import com.techlabs.puremvc.view.components.AddFeed;
	
	import flash.events.Event;
	import flash.events.MouseEvent;
	
	import org.puremvc.as3.interfaces.IMediator;
	import org.puremvc.as3.interfaces.INotification;
	import org.puremvc.as3.patterns.mediator.Mediator;

	/**
	 * The AddFeedMediator relates to the AddFeed MXML component
	 * and serves to perform all the visual logic and handling 
	 * of AddFeed component
	 * 
	 * */
	public class AddFeedMediator extends Mediator implements IMediator
	{
		// Cannonical name of the Mediator
        public static const NAME:String = "AddFeedMediator";
		
		public function AddFeedMediator(viewComponent:Object=null)
		{
			super(NAME, viewComponent);
			/*There are several reasons why I chose to have an init method
			instead of just initializing in the constructor, but that's a different topic.
			*/
			init()
		}
		
		private function init():void
		{
			//here we connect all the event listeners that we require
			//also we would perform other initialization tasks, like 
			//instantiating variables and such.
			addFeed.addButton.addEventListener(MouseEvent.CLICK, addAFeed);
		}
		
		
		  /**
         * List all notifications this Mediator is interested in.
         * <P>
         * Automatically called by the framework when the mediator
         * is registered with the view.</P>
         * 
         * @return Array the list of Nofitication names
         */
		override public function listNotificationInterests():Array
		{
			return [ApplicationFacade.VIEW_ADD_FEED, 
					ApplicationFacade.VIEW_MAIN_SCREEN];
		}
		
		override public function handleNotification(notification:INotification):void
		{
			switch(notification.getName())
			{
				case ApplicationFacade.VIEW_ADD_FEED:
					addFeed.visible = true;
				break;
				
				case ApplicationFacade.VIEW_MAIN_SCREEN:
					addFeed.visible = false;
				break;
			
			}
		}
		
		 /**
         * Cast the viewComponent to its actual type.
         * 
         * <P>
         * This is a useful idiom for mediators. The
         * PureMVC Mediator class defines a viewComponent
         * property of type Object. </P>
         * 
         * <P>
         * Here, we cast the generic viewComponent to 
         * its actual type in a protected mode. This 
         * retains encapsulation, while allowing the instance
         * (and subclassed instance) access to a 
         * strongly typed reference with a meaningful
         * name.</P>
         * 
         * @return MainScreen the viewComponent cast to org.puremvc.as3.demos.flex.appskeleton.view.components.MainScreen
         */
		 
        protected function get addFeed():AddFeed
		{
            return viewComponent as AddFeed;
        }
		
		/*********************************/
		/* events handler 				 */
		/*********************************/
		
		private function addAFeed(evt:Event):void
		{
			//when we click the add a feed, we should first perform some sort of check
			//to ensure that the fields are properly filed and then dispatch the appropriate 
			//notifications, in this case we want to call the AddFeedCommand and close the
			//this component while enabling the main one.
			sendNotification(ApplicationFacade.FEED_ADDED, {feedName:addFeed.nameInput.text, feedUrl:addFeed.urlInput.text});
			
			sendNotification(ApplicationFacade.VIEW_MAIN_SCREEN);
		}
		
	}
}